﻿DECLARE @ChannelSetName AS NVARCHAR(MAX)
SET @ChannelSetName = 'Default'
DECLARE @ChannelName AS NVARCHAR(MAX)
SET @ChannelName = 'Everyone'

IF NOT EXISTS (SELECT * FROM NB_ChannelSet  WHERE Shared = 1)
BEGIN
	INSERT INTO NB_ChannelSet (Name, Shared) VALUES (@ChannelSetName, 1)   
	INSERT INTO NB_View (ChannelSetID, DeviceID, ViewID, ExtendedProperties) VALUES ((SELECT TOP 1 ChannelSetID FROM NB_ChannelSet), 1, '3E2BF243-A2B5-463E-8D85-088CF39D4FFF', '{"name":"Notification view"}') /* Hardcoded DeviceID = webpart, GUID = notification pannel, Extended properties. These values are always the same as they are defined in other places*/
END

IF NOT EXISTS (SELECT * FROM NB_Channel WHERE ParentChannelID IS NOT NULL)
BEGIN
	DECLARE @NewChannelID AS INT
	INSERT INTO NB_Channel (ParentChannelID, Name, BreakRightsInherit, SortOrder, CanContainItems) VALUES (1, @ChannelName, 0, 1, 1)
	SET @NewChannelID = @@IDENTITY
	INSERT INTO NB_Mandatory (ChannelID, PrincipalID, ChannelSetID) VALUES (@NewChannelID, 1, (SELECT TOP 1 ChannelSetID FROM NB_ChannelSet))
	INSERT INTO NB_ChannelRights (ChannelID, PrincipalID, [Level]) VALUES (@NewChannelID, 1, 1)
END